#!/bin/sh
#
# $Header: evt.sh 14-oct-2002.14:09:05 gchen Exp $
#
# evt.sh
#
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      evt.sh - EVenT integration shell script
#
#    DESCRIPTION
#      This shell script takes the node name, ORACLE_HOME, resource name
#      and event type as arguments from standard input. It then parses the
#      resource name and generates the arguments list and event payload for
#      OEM and third party event callout
#
#    NOTES
#      N/A
#
#    MODIFIED   (MM/DD/YY)
#    gchen       10/09/02 - Add node down event
#    gchen       07/15/02 - Change user callout location
#    gchen       07/01/02 - gchen_has_event
#    gchen       07/01/02 - Add comments
#    gchen       06/27/02 - Creation
#

# Get event information from stdin

IFS=':'
read evtname onode ohome racgh resname evttyp

# Get set ORACLE_HOME

ORACLE_HOME=$ohome
set ORACLE_HOME=$ohome
export ORACLE_HOME

evttyp=`echo ${evttyp} |/usr/bin/sed -e 's/^ *//'`
evttyp=`echo ${evttyp} |/usr/bin/sed -e 's/ *$//' -e 's/\ *//'`

if [ ${evttyp} = "up" ]
then
	status="clear"  
elif [ ${evttyp} = "down" ]
then
	status="alert"
elif [ ${evttyp} = "nodedown" ]
then
	status="down"
fi

# Parse resource name to get resource information

ora=`echo ${resname} |/usr/bin/sed -e 's/^ *//' -e 's/\..*//'`
rem=`echo ${resname} |/usr/bin/sed -e 's/^ *//' -e 's/^[^\.]*\.//'`

dbname=`echo ${rem} |/usr/bin/sed -e 's/\..*//'`
rem=`echo ${rem} |/usr/bin/sed -e 's/^[^\.]*\.//'`

var1=`echo ${rem} |/usr/bin/sed -e 's/\..*//'`

moreComp=`echo ${rem} |/usr/bin/sed -e 's/[^\.]*//g'`

if [ ${evttyp} = "nodedown" ]
then
down_node=`echo ${evtname} |/usr/bin/sed -e 's/^ *//' -e 's/^[^\.]*\.//'`
down_node=`echo ${down_node} |/usr/bin/sed -e 's/^ *//' -e 's/^[^\.]*\.//'`
down_node=`echo ${down_node} |/usr/bin/sed -e 's/^ *//' -e 's/\..*//'`

elif [ "${moreComp}" ]
then
	rem=`echo ${rem} |/usr/bin/sed -e 's/^[^\.]*\.//'`

	var2=`echo ${rem} |/usr/bin/sed -e 's/\..*//'`

	moreComp=`echo ${rem} |/usr/bin/sed -e 's/[^\.]*//g'`

	if [ "${moreComp}" ]
	then
		rem=`echo ${rem} |/usr/bin/sed -e 's/^[^\.]*\.//'`

		var3=`echo ${rem} |/usr/bin/sed -e 's/\..*//'`

		moreComp=`echo ${rem} |/usr/bin/sed -e 's/[^\.]*//g'`

		if [ "${moreComp}" ]
		then
			rem=`echo ${rem} |/usr/bin/sed -e 's/^[^\.]*\.//'`
		fi
	fi
fi

# Use OEM words for event type

nodename=`hostname`

# Raise oem event based on the type of the resource

if [ ${evttyp} = "nodedown" ]
then
# No need to post node down event to OEM
	evt="NODE"
elif [ "${var3}" = "srv" ]
then
	if [ "${nodename}" = "${onode}" ]
	then
		${ORACLE_HOME}/bin/oemevent /oracle/rac/$dbname/servicemember_updown \
		 ${nodename} $status [SERVICEMEMBER ${evttyp}] DATABASE_NAME=$dbname \
		 SERVICE_NAME=${var1} INSTANCE_NAME=${var2} NODE_NAME=${nodename}

		evt="SERVICEMEMBER"
		srvname=${var1}
		instname=${var2}
	fi
elif [ "${var3}" = "" ]
then
	if [ "${var2}" = "cs" ]
	then
		if [ "${nodename}" = "${onode}" ]
		then
			$ORACLE_HOME/bin/oemevent /oracle/rac/$dbname/service_updown \
			 ${nodename} $status [SERVICE ${evttyp}] DATABASE_NAME=$dbname \
			 SERVICE_NAME=${var1}
			evt="SERVICE"
			srvname=${var1}
		fi
	elif [ "${var2}" = "inst" ]
	then
		if [ "${nodename}" = "${onode}" ]
		then
			$ORACLE_HOME/bin/oemevent /oracle/rac/$dbname/instance_updown \
			 ${nodename} $status [INSTANCE ${evttyp}] DATABASE_NAME=$dbname \
			 INSTANCE_NAME=${var1} NODE_NAME=${nodename}
			evt="INSTANCE"
			instname=${var1}
		fi
	elif [ "${var2}" = "" ]
	then
		if [ "${var1}" = "db" ]
		then
			if [ "${nodename}" = "${onode}" ]
			then
				$ORACLE_HOME/bin/oemevent /oracle/rac/$dbname/database_updown \
				 ${nodename} $status [DATABASE ${evttyp}] DATABASE_NAME=$dbname
				evt="DATABASE"
			fi
		fi
	fi
fi

# Run other event callouts

for prog in $ORACLE_HOME/racg/usrco/* 
do 
if [ ${evttyp} = "nodedown" ]
then
	[ -x $prog ] && $prog post ${evt} host=${down_node} status=down
else
	[ -x $prog ] && $prog post ${evt} status=${evttyp} database=$dbname service=${srvname} \
                                 instance=${instname} host=${nodename}
fi
done
